# 帳票設計書 2-Nodes Report

## 概要

本ドキュメントは、OpenSearchの `_cat/nodes` APIが出力するNodes Reportの帳票設計書である。クラスタ内の各ノード情報をテキストテーブル形式で出力するCat APIエンドポイントの仕様を定義する。

### 本帳票の処理概要

Nodes Reportは、OpenSearchクラスタに参加している各ノードの詳細情報を一覧表示する帳票である。ノード名、IPアドレス、ヒープ使用量、CPU使用率、ロードアベレージなどの基本情報から、インデックス統計、キャッシュ統計、セグメント統計まで幅広い情報を出力する。

**業務上の目的・背景**：クラスタ内の各ノードのリソース使用状況を把握し、負荷分散の状態確認やキャパシティプランニングに活用する。ノード単位でのヒープ、CPU、ディスク使用量を即座に確認できることで、リソース逼迫の早期検知を実現する。

**帳票の利用シーン**：クラスタの日常監視、パフォーマンス問題の調査、キャパシティプランニング、ノード追加・削除の判断、ノードの役割確認に利用される。

**主要な出力内容**：
1. ノード識別情報（ID、名前、IP、バージョン）
2. リソース使用量（ヒープ、RAM、CPU、ディスク、ファイルディスクリプタ）
3. ノードロール情報（クラスタマネージャ、データ、インジェスト等）
4. インデックス操作統計（検索、インデキシング、マージ、リフレッシュ等）
5. キャッシュ統計（クエリキャッシュ、リクエストキャッシュ、フィールドデータ）

**帳票の出力タイミング**：ユーザーが `GET /_cat/nodes` エンドポイントにHTTPリクエストを送信した時点で即座に出力される。

**帳票の利用者**：クラスタ管理者、SRE、運用監視チーム、パフォーマンスエンジニア。

## 帳票種別

一覧表（テキストテーブル形式のノード情報一覧）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 154 | Cat ノード | `GET /_cat/nodes` | HTTP GETリクエスト |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（text/plain）/ JSON（application/json） |
| 用紙サイズ | N/A（REST APIレスポンス） |
| 向き | N/A |
| ファイル名 | N/A（HTTPレスポンスボディとして返却） |
| 出力方法 | HTTPレスポンス |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

ノード数分の行を持つテキストテーブルとしてノード情報を出力する。デフォルト表示カラムとオプション表示カラムに分かれる。

```
┌──────────────────────────────────────────────────────┐
│ ip     heap.percent  ram.percent  cpu  load_1m  ...  │
├──────────────────────────────────────────────────────┤
│ 10.0.0.1   45          78         12   0.50    ...  │
│ 10.0.0.2   62          85         25   1.20    ...  │
└──────────────────────────────────────────────────────┘
```

### 明細部（デフォルト表示カラム）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | ip | IPアドレス | DiscoveryNode.getHostAddress() | 文字列 |
| 2 | heap.percent | ヒープ使用率 | JvmStats.getMem().getHeapUsedPercent() | 右寄せ数値 |
| 3 | ram.percent | メモリ使用率 | OsStats.getMem().getUsedPercent() | 右寄せ数値 |
| 4 | cpu | CPU使用率 | OsStats.getCpu().getPercent() | 右寄せ数値 |
| 5 | load_1m | 1分間ロードアベレージ | OsStats.getCpu().getLoadAverage()[0] | 右寄せ小数 |
| 6 | load_5m | 5分間ロードアベレージ | OsStats.getCpu().getLoadAverage()[1] | 右寄せ小数 |
| 7 | load_15m | 15分間ロードアベレージ | OsStats.getCpu().getLoadAverage()[2] | 右寄せ小数 |
| 8 | node.role | ノードロール略称 | DiscoveryNodeRole.roleNameAbbreviation() | 文字列 |
| 9 | node.roles | 全ロール名 | DiscoveryNodeRole.roleName() | カンマ区切り文字列 |
| 10 | cluster_manager | クラスタマネージャフラグ | nodes.getClusterManagerNodeId() | *（マネージャ）/ - |
| 11 | name | ノード名 | DiscoveryNode.getName() | 文字列 |

### 明細部（オプションカラム - default:false）

合計80以上のカラムが定義されている。主なカテゴリ：

- **ノード識別**: id, pid, port, http_address, version, type, build, jdk
- **ディスク**: disk.total, disk.used, disk.avail, disk.used_percent
- **ヒープ/メモリ**: heap.current, heap.max, ram.current, ram.max
- **ファイルディスクリプタ**: file_desc.current, file_desc.percent, file_desc.max
- **インデキシング統計**: indexing.index_total, indexing.index_time, indexing.delete_total 等
- **検索統計**: search.query_total, search.query_time, search.fetch_total 等
- **マージ統計**: merges.total, merges.total_time, merges.total_size 等
- **セグメント統計**: segments.count, segments.memory 等
- **キャッシュ統計**: query_cache.memory_size, request_cache.memory_size 等

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| full_id | trueの場合、ノードIDをフル表示（デフォルト: false、先頭4文字） | No |
| local | ローカルノード情報のみ取得（非推奨パラメータ） | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| - | `s` パラメータで任意指定可能 | 任意 |

### 改ページ条件

改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| データソース | 用途 | 取得方法 |
|-----------|------|---------|
| ClusterStateResponse | ノード一覧・クラスタマネージャ情報 | ClusterStateRequest（nodes=true） |
| NodesInfoResponse | ノード情報（JVM、OS、Process、HTTP） | NodesInfoRequest（JVM, OS, PROCESS, HTTP） |
| NodesStatsResponse | ノード統計（JVM、OS、FS、Process、Script、Indices） | NodesStatsRequest（indices=true + 各メトリクス） |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| disk.used | diskTotal.getBytes() - diskAvailable.getBytes() | なし | バイト単位 |
| disk.used_percent | 100.0 * diskUsed / diskTotal | 小数点第2位（%.2f） | diskTotal が0の場合は1.0 |
| load_1m/5m/15m | OsStats.getCpu().getLoadAverage()[index] | 小数点第2位（%.2f） | -1の場合はnull表示 |
| file_desc.percent | (100d * used) / max | short型変換 | maxが0以下の場合は0 |
| node.role | 各ロールの略称を結合 | なし | 空の場合は「-」 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[GET /_cat/nodes リクエスト受信] --> B[doCatRequest]
    B --> C[ClusterStateRequest 実行 - ノード一覧取得]
    C --> D[NodesInfoRequest 実行 - ノード情報取得]
    D --> E[NodesStatsRequest 実行 - ノード統計取得]
    E --> F[buildTable で3つのレスポンスを統合]
    F --> G[RestTable.buildResponse でレスポンス生成]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ノード情報取得失敗 | 特定ノードが応答しない | ノード統計がnull表示 | 各カラムでnullチェックが行われ、nullの場合は空欄表示 |
| 非推奨パラメータ警告 | `local` パラメータ使用時 | DeprecationWarning ヘッダー | `local` パラメータの使用を中止 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | ノード数分の行（通常数個～数百） |
| 目標出力時間 | 数百ミリ秒（3段階の内部API呼び出しの合計） |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- ノードのIPアドレス、ポート番号等のインフラ情報が含まれるため、アクセス制御が推奨される。
- `local` パラメータは非推奨であり、バージョン8.0で廃止予定。

## 備考

- 3段階の非同期API呼び出し（ClusterState → NodesInfo → NodesStats）で構成されるため、他のCat APIより応答時間が長い。
- `cluster_manager` ヘッダーには後方互換性のため `master` エイリアスが残されている。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RestNodesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestNodesAction.java` | 行167-421: getTableWithHeader() で全カラム定義を確認。80超のカラムがdefault:true/falseで分類されている |

**読解のコツ**: `default:false` のカラムは `h` パラメータで明示的に指定しないと出力されない。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestNodesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestNodesAction.java` | 行112-164: doCatRequest() で3段階の非同期チェーン呼び出し |

**主要処理フロー**:
1. **行113-118**: ClusterStateRequest でノード一覧取得
2. **行127-135**: NodesInfoRequest でJVM/OS/Process/HTTP情報取得
3. **行139-149**: NodesStatsRequest でJVM/OS/FS/Process/Script/Indices統計取得
4. **行154-156**: buildTable() で3レスポンスを統合してテーブル構築

#### Step 3: テーブル構築ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RestNodesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestNodesAction.java` | 行423-646: buildTable() でノードごとに行を構築 |

### プログラム呼び出し階層図

```
AbstractCatAction.prepareRequest()
    |
    +-- RestNodesAction.doCatRequest() [行112]
           |
           +-- client.admin().cluster().state() [行124]
           |      |
           |      +-- client.admin().cluster().nodesInfo() [行136]
           |             |
           |             +-- client.admin().cluster().nodesStats() [行151]
           |                    |
           |                    +-- buildTable() [行423]
           |                           |
           |                           +-- getTableWithHeader() [行167]
           |                           +-- DiscoveryNodes 反復 [行435]
           |
           +-- RestTable.buildResponse() [行154]
```

### データフロー図

```
[入力]                     [処理]                           [出力]

GET /_cat/nodes  --->  ClusterStateRequest          --->  テキストテーブル
                           |                                (ノード数分の行)
                           v
                  ClusterStateResponse (ノード一覧)
                           |
                           v
                  NodesInfoRequest
                           |
                           v
                  NodesInfoResponse (ノード詳細情報)
                           |
                           v
                  NodesStatsRequest
                           |
                           v
                  NodesStatsResponse (ノード統計)
                           |
                           v
                  buildTable() で統合 → Table
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestNodesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestNodesAction.java` | ソース | Nodes Report メイン処理 |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API共通基底クラス |
| RestNodesActionTests.java | `server/src/test/java/org/opensearch/rest/action/cat/RestNodesActionTests.java` | テスト | ユニットテスト |
| NodeInfo.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/info/NodeInfo.java` | ソース | ノード情報データ構造 |
| NodeStats.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/NodeStats.java` | ソース | ノード統計データ構造 |
| DiscoveryNode.java | `server/src/main/java/org/opensearch/cluster/node/DiscoveryNode.java` | ソース | ディスカバリーノードデータ構造 |
